﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CardLibrary
{
    public class CardSet
    {
        public SuperCard[] cardArray;

        public CardSet()
        {
            cardArray = new SuperCard[52];
            int cardCount = 0;

            for (Suit suit = Suit.Club; suit <= Suit.Spade; suit++)
            {
                for (Rank rank = Rank.Deuce; rank <= Rank.Ace; rank++)
                {
                    switch (suit)
                    {
                        case Suit.Club:
                            cardArray[cardCount++] = new CardClub(rank);
                            break;
                        case Suit.Diamond:
                            cardArray[cardCount++] = new CardDiamond(rank);
                            break;
                        case Suit.Heart:
                            cardArray[cardCount++] = new CardHeart(rank);
                            break;
                        case Suit.Spade:
                            cardArray[cardCount++] = new CardSpade(rank);
                            break;
                    }

                }
            }
        }
    }
}
